/*
 * Decompiled with CFR 0.152.
 */
package CommDSPMidlet;

import CommDSPMidlet.CDSP;
import java.io.DataOutputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.StreamConnection;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class CDSPCanvas
extends Canvas {
    private CDSP midlet;
    private int width;
    private int height;
    private int code;
    public double data;
    private boolean Connected = false;
    public boolean aboutFlag = false;
    public int reference;
    private int ID_ModeControleVitesse = 240;
    private int ID_ModeControlePosition = 243;
    private int ID_ModeControle = 246;
    public boolean VitessePositionFlag = true;
    private Image img;
    StreamConnection conn = null;
    DataOutputStream dataout = null;
    String err = "";
    private String url = "btspp://008098644C10:1;authenticate=false;encrypt=false;master=false";
    byte[] Out = new byte[4];

    public CDSPCanvas(CDSP cdsp) {
        this.midlet = cdsp;
        this.data = 0.0;
        this.code = 0;
        this.width = this.getWidth();
        this.height = this.getHeight();
        try {
            this.img = Image.createImage((String)"/res/logogreen.png");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.img = null;
        }
    }

    public void Connect() {
        Thread th = new Thread(){

            public void run() {
                System.out.println("CDSPCanvas.btConnect.run()");
                try {
                    CDSPCanvas.this.setTitle("Connecting to BT device");
                    CDSPCanvas.this.conn = (StreamConnection)Connector.open((String)CDSPCanvas.this.url);
                    CDSPCanvas.this.setTitle("Connected to BT");
                    System.out.println("Sending message out");
                }
                catch (Exception e) {
                    CDSPCanvas.this.setTitle("Connecting failed");
                    System.out.println("Connecting to BT device Failed");
                    CDSPCanvas.this.err = e.toString();
                    System.out.println(e);
                }
                CDSPCanvas.this.removeCommand(((CDSPCanvas)CDSPCanvas.this).midlet.connectCommand);
                CDSPCanvas.this.addCommand(((CDSPCanvas)CDSPCanvas.this).midlet.DisconnectCommand);
                CDSPCanvas.this.Connected = true;
            }
        };
        th.start();
    }

    public void Disconnect() {
        try {
            if (this.conn != null) {
                this.conn.close();
                this.setTitle("Disconnected OK");
                System.out.println("Disconnection to BT device OK");
            }
        }
        catch (Exception e) {
            this.err = e.toString();
            this.setTitle("Disconnection Failed");
            System.out.println(e);
        }
        this.removeCommand(this.midlet.DisconnectCommand);
        this.addCommand(this.midlet.connectCommand);
        this.Connected = false;
    }

    public void Send() {
        if (!this.Connected) {
            System.out.println("Not connected, can not send");
            return;
        }
        this.code = this.VitessePositionFlag ? this.ID_ModeControleVitesse : this.ID_ModeControlePosition;
        this.EnvoieSemiWord(this.code, this.data);
    }

    public void SendConfig() {
        if (!this.Connected) {
            System.out.println("Not connected, can not send");
            return;
        }
        this.data = this.VitessePositionFlag ? 0.0 : 1.0;
        this.EnvoieSemiWord(this.ID_ModeControle, this.data);
    }

    protected void paint(Graphics g) {
        g.setColor(0xFFFFFF);
        g.fillRect(0, 0, this.width, this.height);
        g.setColor(0);
        if (this.img != null) {
            g.drawImage(this.img, this.width / 2, this.height / 4 - 10, 3);
        }
        g.setFont(Font.getFont((int)64, (int)1, (int)16));
        if (this.aboutFlag) {
            g.drawString("Commande de MAS", this.width / 2, this.height * 4 / 8, 65);
            g.drawString("\u00e0 distance", this.width / 2, this.height * 5 / 8, 65);
            g.drawString("Lotfi BAGHLI", this.width / 2, this.height * 7 / 8, 65);
            g.setFont(Font.getFont((int)64, (int)0, (int)0));
            g.drawString("Ecrit par :", this.width / 2, this.height * 6 / 8, 65);
            g.drawString("Juin 2007", this.width / 2, (int)((double)this.height * 7.8 / 8.0), 65);
            this.aboutFlag = false;
        } else {
            if (this.VitessePositionFlag) {
                g.drawString("Speed reference", this.width / 2, this.height * 2 / 4 + 20, 65);
            } else {
                g.drawString("Position reference", this.width / 2, this.height * 2 / 4 + 20, 65);
            }
            String SS = String.valueOf(this.data);
            g.drawString(SS, this.width / 2, this.height * 3 / 4, 65);
        }
    }

    public void keyPressed(int key) {
        switch (key) {
            case 52: {
                this.data -= 1.0;
                this.Send();
                break;
            }
            case 54: {
                this.data += 1.0;
                this.Send();
                break;
            }
            case 48: {
                this.data = 0.0;
                this.Send();
                break;
            }
            case 49: {
                this.VitessePositionFlag = true;
                this.SendConfig();
                break;
            }
            case 51: {
                this.VitessePositionFlag = false;
                this.SendConfig();
            }
        }
        this.repaint();
    }

    public void keyRepeated(int key) {
        switch (key) {
            case 52: {
                this.data -= 10.0;
                this.Send();
                break;
            }
            case 54: {
                this.data += 10.0;
                this.Send();
            }
        }
        this.repaint();
    }

    private void EnvoieSemiWord(int code, double data) {
        int idata = (int)data * 4;
        this.Out[0] = (byte)code;
        this.Out[1] = (byte)(idata & 0x7F);
        this.Out[2] = (byte)(idata >> 7 & 0x7F);
        if (this.Connected) {
            Thread th = new Thread(){

                public void run() {
                    System.out.println("CDSPCanvas.Send");
                    try {
                        CDSPCanvas.this.setTitle("Sending to BT device");
                        System.out.println("Sending message out");
                        CDSPCanvas.this.dataout = CDSPCanvas.this.conn.openDataOutputStream();
                        CDSPCanvas.this.dataout.write(CDSPCanvas.this.Out, 0, 3);
                        CDSPCanvas.this.dataout.flush();
                        System.out.println("Write and flush ok");
                        Thread.sleep(1000L);
                        CDSPCanvas.this.dataout.close();
                    }
                    catch (Exception e) {
                        CDSPCanvas.this.setTitle("Sending failed");
                        System.out.println("Sending to BT device Failed");
                        CDSPCanvas.this.err = e.toString();
                        System.out.println(e);
                    }
                }
            };
            th.start();
        } else {
            System.out.println("Erreur Port Com non ouvert");
        }
    }
}

